package ru.yandex.travel.api.config.common;

import io.grpc.Channel;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.services.workflow_management.WorkflowManagementClientFactory;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;
import ru.yandex.travel.workflow.management.proto.WorkflowManagementServiceGrpc;

@Configuration
public class WorkflowManagementClientConfiguration {

    @Bean
    public WorkflowManagementClientFactory workflowManagementClientFactory(@Qualifier("OrchestratorGrpcChannelFactory") HAGrpcChannelFactory haGrpcChannelFactory) {
        return () -> {
            Channel channel = haGrpcChannelFactory.getMasterChannel();
            return WorkflowManagementServiceGrpc.newFutureStub(channel);
        };
    }
}
