package ru.yandex.travel.api.config.common;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
@ConfigurationPropertiesBinding
public class ZonedDateTimeConverter implements Converter<String, ZonedDateTime> {
    final static String LOCAL_DATE_PATTERN = "yyyy-MM-dd";
    final static ZoneId LOCAL_DATE_ZONE = ZoneId.ofOffset("UTC", ZoneOffset.ofHours(3));  // MSC

    @Override
    public ZonedDateTime convert(String source) {
        if (source.isEmpty()) {
            return null;
        }

        if (!source.contains(":")) {
            LocalDate ld = LocalDate.parse(source, DateTimeFormatter.ofPattern(LOCAL_DATE_PATTERN));
            return ld.atStartOfDay(LOCAL_DATE_ZONE);
        } else {
            return ZonedDateTime.parse(source);
        }
    }
}
