package ru.yandex.travel.api.config.dictionaries;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.api.services.dictionaries.DictionaryProperties;
import ru.yandex.travel.api.services.dictionaries.avia.AviaAirlineDictionary;
import ru.yandex.travel.api.services.dictionaries.avia.AviaAirportDictionary;
import ru.yandex.travel.api.services.dictionaries.avia.AviaSettlementDictionary;

@ConditionalOnProperty("dictionaries.enabled")
@Configuration
public class DictionariesConfiguration {
    @Bean
    @ConfigurationProperties("dictionaries.settlements")
    @Validated
    public DictionaryProperties aviaSettlementDictionaryProperties() {
        return new DictionaryProperties();
    }

    @Bean
    public AviaSettlementDictionary aviaSettlementDictionary(DictionaryProperties aviaSettlementDictionaryProperties) {
        return new AviaSettlementDictionary(aviaSettlementDictionaryProperties);
    }

    @Bean
    @ConfigurationProperties("dictionaries.airports")
    @Validated
    public DictionaryProperties aviaAirportDictionaryProperties() {
        return new DictionaryProperties();
    }

    @Bean
    public AviaAirportDictionary aviaAirportDictionary(DictionaryProperties aviaAirportDictionaryProperties) {
        return new AviaAirportDictionary(aviaAirportDictionaryProperties);
    }

    @Bean
    @ConfigurationProperties("dictionaries.airlines")
    @Validated
    public DictionaryProperties aviaAirlineDictionaryProperties() {
        return new DictionaryProperties();
    }

    @Bean
    public AviaAirlineDictionary aviaAirlineDictionary(DictionaryProperties aviaAirlineDictionaryProperties) {
        return new AviaAirlineDictionary(aviaAirlineDictionaryProperties);
    }
}
