package ru.yandex.travel.api.config.dictionaries;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.services.dictionaries.avia.AviaAirlineDictionary;
import ru.yandex.travel.api.services.dictionaries.avia.AviaAirportDictionary;
import ru.yandex.travel.api.services.dictionaries.avia.AviaSettlementDictionary;

/**
 * Service stubs for local development and tests.
 */
@ConditionalOnProperty(value = "dictionaries.enabled", havingValue = "false")
@Configuration
public class EmptyDictionariesConfiguration {
    @Bean
    public AviaSettlementDictionary emptyAviaSettlementDictionary() {
        return AviaSettlementDictionary.createEmpty();
    }

    @Bean
    public AviaAirportDictionary emptyAviaAirportDictionary() {
        return AviaAirportDictionary.createEmpty();
    }

    @Bean
    public AviaAirlineDictionary emptyAviaAirlineDictionary() {
        return AviaAirlineDictionary.createEmpty();
    }
}
