package ru.yandex.travel.api.config.hotels;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.DefaultBNovoClient;

@Configuration
@EnableConfigurationProperties(BNovoConfigurationProperties.class)
public class BNovoConfiguration {
    @Bean
    public BNovoClient bNovoClient(AsyncHttpClientWrapper bNovoAhcWrapper, Retry retryHelper,
                                   BNovoConfigurationProperties properties) {
        return new DefaultBNovoClient(bNovoAhcWrapper, properties.getClient(), retryHelper);
    }
}
