package ru.yandex.travel.api.config.hotels;

import javax.validation.Valid;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClientProperties;

@ConfigurationProperties(prefix = "hotels-booking-flow.providers.bnovo", ignoreUnknownFields = false)
@Data
@Validated
public class BNovoConfigurationProperties {
    @Valid
    private BNovoClientProperties client;

    private boolean debugShowRateInfo;

    private String yandexNumberPrefix;
}
