package ru.yandex.travel.api.config.hotels

import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.travel.api.config.common.AhcConfiguration
import ru.yandex.travel.commons.retry.Retry
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient
import ru.yandex.travel.hotels.common.partners.bronevik.DefaultBronevikClient

@Configuration
@EnableConfigurationProperties(BronevikConfigurationProperties::class)
open class BronevikConfiguration {

    @Bean
    open fun bronevikClient(
        @Autowired properties: BronevikConfigurationProperties,
        @Autowired retryHelper: Retry
    ): BronevikClient {
        return DefaultBronevikClient(properties.client, AhcConfiguration.DEFAULT_HTTP_LOGGER, retryHelper)
    }
}
