package ru.yandex.travel.api.config.hotels

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import org.springframework.validation.annotation.Validated
import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClientProperties
import javax.validation.Valid
import javax.validation.constraints.NotEmpty

@ConstructorBinding
@ConfigurationProperties(prefix = "hotels-booking-flow.providers.bronevik", ignoreUnknownFields = false)
@Validated
open class BronevikConfigurationProperties(
    open var client: @Valid BronevikClientProperties,
    open var partnerLegalData: @Valid LegalData,
    open var yandexNumberPrefix: String?,
    open val enabled: Boolean,
)

@ConstructorBinding
open class LegalData(
    open var name: @NotEmpty String,
    open var address: @NotEmpty String,
    open var ogrn: @NotEmpty String,
    open var workingHours: @NotEmpty String
)
