package ru.yandex.travel.api.config.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.health.HealthCheckedSupplier;
import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.dolphin.BaseDolphinYtCacheProperties;
import ru.yandex.travel.hotels.common.partners.dolphin.DefaultDolphinClient;
import ru.yandex.travel.hotels.common.partners.dolphin.DolphinClient;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.RoomNameNormalizer;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.RoomNameNormalizerRules;

@Configuration
@EnableConfigurationProperties(BaseDolphinYtCacheProperties.class)
@RequiredArgsConstructor
public class DolphinConfiguration {

    private final BaseDolphinYtCacheProperties ytCacheProperties;

    @Bean
    public DolphinClient getDolphinClient(@Qualifier("dolphinAhcWrapper") AsyncHttpClientWrapper dolphinClientWrapper,
                                          DolphinConfigurationProperties properties,
                                          Retry retryHelper) {
        return new DefaultDolphinClient(dolphinClientWrapper, properties.getClient(), retryHelper);
    }

    @Bean
    public RoomNameNormalizerRules getRoomNameNormalizeRules() {
        return RoomNameNormalizerRules.fromBaseProperties(ytCacheProperties);
    }

    @Bean
    public HealthCheckedSupplier<RoomNameNormalizer> roomNameNormalizerSupplier(RoomNameNormalizerRules normalizeRules) {
        return new HealthCheckedSupplier<>(new RoomNameNormalizer(normalizeRules), "dolphin_name_normalizer");
    }
}
