package ru.yandex.travel.api.config.hotels;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.HashMap;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.dolphin.DolphinClientProperties;

@ConfigurationProperties(prefix = "hotels-booking-flow.providers.dolphin", ignoreUnknownFields = false)
@Data
@Validated
public class DolphinConfigurationProperties {
    @NotNull
    @NotEmpty
    private HashMap<Integer, BigDecimal> cancellationPenalties;
    @Valid
    private DolphinClientProperties client;
    @NotNull
    private Duration staticUpdateInterval;
    @NotNull
    private Duration staticRetryInterval;
    @Valid
    private LegalData partnerLegalData;

    @Getter
    @Setter
    public static class LegalData {
        @NotEmpty
        private String name;
        @NotEmpty
        private String address;
        @NotEmpty
        private String ogrn;
        @NotEmpty
        private String workingHours;
    }

}

