package ru.yandex.travel.api.config.hotels;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.expedia.DefaultExpediaClient;
import ru.yandex.travel.hotels.common.partners.expedia.ExpediaClient;
import ru.yandex.travel.hotels.common.partners.expedia.ExpediaClientProperties;

@Configuration
@EnableConfigurationProperties(ExpediaConnectionProperties.class)
public class ExpediaConfiguration {
    private final ExpediaConnectionProperties properties;
    private final AsyncHttpClientWrapper ahcClient;
    private final Retry retryHelper;

    public ExpediaConfiguration(ExpediaConnectionProperties properties,
                                @Qualifier("expediaAhcWrapper") AsyncHttpClientWrapper ahcClient,
                                Retry retryHelper) {
        this.properties = properties;
        this.ahcClient = ahcClient;
        this.retryHelper = retryHelper;
    }

    @Bean
    public ExpediaClient getExpediaClient() {
        ExpediaClientProperties props = new ExpediaClientProperties();
        props.setBaseUrl(properties.getBaseUrl());
        props.setApiSecret(properties.getSecret());
        props.setApiKey(properties.getApiKey());
        props.setDefaultApiVersion(properties.getDefaultApiVersion());
        props.setHttpRequestTimeout(properties.getHttpRequestTimeout());
        props.setHttpReadTimeout(properties.getHttpReadTimeout());
        props.setEnableRetries(true);
        props.setProfileType(properties.getProfileType());
        return new DefaultExpediaClient(props, ahcClient, retryHelper);
    }
}
