package ru.yandex.travel.api.config.hotels;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.expedia.ApiVersion;
import ru.yandex.travel.hotels.common.partners.expedia.ProfileType;

@Validated
@ConfigurationProperties(value = "expedia", ignoreUnknownFields = false)
@Getter
@Setter
public class ExpediaConnectionProperties {
    @NotEmpty
    private String apiKey;

    @NotEmpty
    private String secret;

    @NotNull
    private ApiVersion defaultApiVersion;

    @NotNull
    private String baseUrl;

    @NotNull
    private Duration httpReadTimeout;

    @NotNull
    private Duration httpRequestTimeout;

    @NotNull
    private ProfileType profileType;
}
