package ru.yandex.travel.api.config.hotels;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentracing.Tracer;
import lombok.RequiredArgsConstructor;
import org.asynchttpclient.AsyncHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.geosearch.GeoSearchProperties;
import ru.yandex.travel.hotels.geosearch.GeoSearchService;
import ru.yandex.travel.tvm.TvmWrapper;

import static ru.yandex.travel.api.config.common.AhcConfiguration.DEFAULT_HTTP_LOGGER;

@Configuration
@EnableConfigurationProperties(GeoSearchProperties.class)
@RequiredArgsConstructor
public class GeoSearchConfiguration {

    private final GeoSearchProperties geoSearchProperties;


    private final ObjectMapper objectMapper;

    @Bean
    public AsyncHttpClientWrapper geoSearchAhcWrapper(AsyncHttpClient defaultAhcClient,
                                                      Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "geosearch", tracer, null);
    }

    @Bean
    public GeoSearchService geoSearchService(@Autowired(required = false) TvmWrapper tvm,
                                             @Qualifier(value = "geoSearchAhcWrapper") AsyncHttpClientWrapper client,
                                             Retry retryHelper) {
        return new GeoSearchService(geoSearchProperties, client, objectMapper, tvm, retryHelper);
    }
}
