package ru.yandex.travel.api.config.hotels;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.PartnerConfigService;
import ru.yandex.travel.hotels.common.PartnerConfigServiceProperties;


@Configuration
@EnableConfigurationProperties(PartnerConfigServiceProperties.class)
@RequiredArgsConstructor
public class PartnerConfigConfiguration {

    private final PartnerConfigServiceProperties partnerConfigServiceProperties;

    @Bean
    public PartnerConfigService partnerConfigService() {
        return new PartnerConfigService(partnerConfigServiceProperties);
    }
}
