package ru.yandex.travel.api.config.hotels;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.travelline.DefaultTravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;

@Configuration
public class TravellineConfiguration {
    @Bean
    public TravellineClient getTravellineClient(@Qualifier("travellineAhcWrapper") AsyncHttpClientWrapper travellineClientWrapper,
                                                TravellineConfigurationProperties properties,
                                                Retry retryHelper) {
        return new DefaultTravellineClient(travellineClientWrapper, properties.getClient(), retryHelper);
    }
}
