package ru.yandex.travel.api.config.hotels;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.travelline.TravellineClientProperties;

@ConfigurationProperties(prefix = "hotels-booking-flow.providers.travelline", ignoreUnknownFields = false)
@Data
@Validated
public class TravellineConfigurationProperties {

    @Valid
    private TravellineClientProperties client;

    @Valid
    private LegalData partnerLegalData;

    private String yandexNumberPrefix;

    private boolean debugShowRateInfo;

    @Getter
    @Setter
    public static class LegalData {
        @NotEmpty
        private String name;
        @NotEmpty
        private String address;
        @NotEmpty
        private String ogrn;
        @NotEmpty
        private String workingHours;
    }

}
