package ru.yandex.travel.api.config.hotels.administrator;

import io.grpc.Channel;

import ru.yandex.travel.hotels.administrator.grpc.proto.AdministratorAdminServiceInterfaceGrpc;
import ru.yandex.travel.hotels.administrator.grpc.proto.AdministratorInterfaceGrpc;
import ru.yandex.travel.hotels.administrator.grpc.proto.AdministratorInternalServiceInterfaceGrpc;
import ru.yandex.travel.hotels.administrator.grpc.proto.IdmApiGrpc;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;

public class AdministratorAdminInterfaceProvider {

    private final HAGrpcChannelFactory channelFactory;

    public AdministratorAdminInterfaceProvider(HAGrpcChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public AdministratorAdminServiceInterfaceGrpc.AdministratorAdminServiceInterfaceFutureStub provideAdminInterface() {
        return AdministratorAdminServiceInterfaceGrpc.newFutureStub(getChannel());
    }

    public AdministratorInternalServiceInterfaceGrpc.AdministratorInternalServiceInterfaceFutureStub provideInternalInterface() {
        return AdministratorInternalServiceInterfaceGrpc.newFutureStub(getChannel());
    }

    public AdministratorInterfaceGrpc.AdministratorInterfaceFutureStub provideInterface() {
        return AdministratorInterfaceGrpc.newFutureStub(getChannel());
    }

    public IdmApiGrpc.IdmApiFutureStub idmInterface() {
        return IdmApiGrpc.newFutureStub(getChannel());
    }

    private Channel getChannel() {
        return channelFactory.getFastestChannel();
    }

}
