package ru.yandex.travel.api.config.hotels.extranet;

import java.util.List;

import io.opentracing.Tracer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.services.extranet.ExtranetClientFactory;
import ru.yandex.travel.hotels.extranet.HotelsExtranetApiServiceGrpc;
import ru.yandex.travel.hotels.extranet.HotelsExtranetAuthApiServiceGrpc;
import ru.yandex.travel.hotels.extranet.HotelsExtranetIdmServiceGrpc;
import ru.yandex.travel.hotels.extranet.PingServiceV1Grpc;
import ru.yandex.travel.hotels.proto.TPingRpcReq;
import ru.yandex.travel.orders.client.ChannelState;
import ru.yandex.travel.orders.client.GrpcServiceConfigurationBase;
import ru.yandex.travel.orders.client.HAGrpcChannelFactory;
import ru.yandex.travel.tvm.TvmWrapper;

import static ru.yandex.travel.commons.concurrent.FutureUtils.buildCompletableFuture;

@Configuration
@EnableConfigurationProperties(ExtranetConfigurationProperties.class)
public class ExtranetConfiguration extends GrpcServiceConfigurationBase {
    public ExtranetConfiguration(ExtranetConfigurationProperties properties, Tracer tracer) {
        super(properties, tracer);
    }

    @Bean
    public ExtranetClientFactory extranetClientFactory(@Qualifier("ExtranetGrpcChannelFactory") HAGrpcChannelFactory haGrpcChannelFactory) {
        return new ExtranetClientFactory() {
            @Override
            public HotelsExtranetApiServiceGrpc.HotelsExtranetApiServiceFutureStub createDataServiceFutureStub() {
                return HotelsExtranetApiServiceGrpc.newFutureStub(haGrpcChannelFactory.getRoundRobinChannel());
            }

            @Override
            public HotelsExtranetAuthApiServiceGrpc.HotelsExtranetAuthApiServiceFutureStub createAuthServiceFutureStub() {
                return HotelsExtranetAuthApiServiceGrpc.newFutureStub(haGrpcChannelFactory.getRoundRobinChannel());
            }

            @Override
            public HotelsExtranetIdmServiceGrpc.HotelsExtranetIdmServiceFutureStub createIdmServiceFutureStub() {
                return HotelsExtranetIdmServiceGrpc.newFutureStub(haGrpcChannelFactory.getRoundRobinChannel());
            }
        };
    }

    @Bean("ExtranetGrpcChannelFactory")
    public HAGrpcChannelFactory haGrpcChannelFactory(@Autowired(required = false) TvmWrapper tvm) {
        return getGrpcChannelFactory(tvm,
                channel -> buildCompletableFuture(ru.yandex.travel.hotels.extranet.PingServiceV1Grpc
                        .newFutureStub(channel)
                        .ping(TPingRpcReq.newBuilder().build())
                ).thenApply((rsp) -> rsp.getIsReady() ? ChannelState.READY : ChannelState.NOT_READY),
                null,
                List.of(PingServiceV1Grpc.getPingMethod()));
    }
}
