package ru.yandex.travel.api.endpoints.admin.req_rsp;

import java.util.List;

import lombok.Data;

import ru.yandex.travel.orders.commons.proto.ESnippet;

@Data
public class AdminGetOrderReqV1 {
    private String orderId;
    private String prettyId;
    private List<ESnippet> snippets;

    public AdminGetOrderReqV1(String id, String prettyId, ESnippet[] snippets) {
        this.orderId = id;
        this.prettyId = prettyId;
        if (snippets != null) {
            this.snippets = List.of(snippets);
        }
    }
}
