package ru.yandex.travel.api.endpoints.admin.req_rsp;

import java.time.Instant;

import javax.validation.constraints.NotNull;

import lombok.Data;

import ru.yandex.travel.orders.admin.proto.EPartnerType;
import ru.yandex.travel.orders.admin.proto.EPaymentScheduleType;
import ru.yandex.travel.orders.admin.proto.TAdminSorterType;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;
import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.commons.proto.ESnippet;

@Data
public class AdminListOrdersReqV1 {
    @NotNull
    private int offset;
    @NotNull
    private int limit;
    private String orderIdFilter;
    private String prettyIdFilter;
    private String providerIdFilter;
    private String emailFilter;
    private String phoneFilter;
    private Instant createdAtFromFilter;
    private Instant createdAtToFilter;
    private EOrderType orderTypeFilter;
    private EDisplayOrderType displayOrderTypeFilter;
    private EDisplayOrderState orderStateFilter;
    private EPartnerType partnerFilter;
    private String purchaseTokenFilter;
    private String cardMaskFilter;
    private String rrnFilter;
    private String passengerNamesFilter;
    private Boolean isBrokenFilter;
    private EPaymentScheduleType paymentScheduleTypeFilter;
    private String ticketNumberFilter;
    private String yandexUidFilter;
    private String carrierFilter;
    private String referralPartnerIdFilter;

    private TAdminSorterType[] sorters;

    private ESnippet[] snippets;

}
