package ru.yandex.travel.api.endpoints.admin.req_rsp;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.springframework.validation.annotation.Validated;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ChangeEmailReqV1.ChangeEmailReqV1Builder.class)
@Validated
public class ChangeEmailReqV1 {
    @NotEmpty
    private String orderId;
    @NotEmpty
    @Email
    private String newEmail;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ChangeEmailReqV1Builder {
    }
}
