package ru.yandex.travel.api.endpoints.admin.req_rsp;

import javax.validation.constraints.NotEmpty;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.springframework.validation.annotation.Validated;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ManualFullMoneyRefundReqV1.ManualFullMoneyRefundReqV1Builder.class)
@Validated
public class ManualFullMoneyRefundReqV1 {
    @NotEmpty
    private String orderId;
    @NotEmpty
    private String adminActionToken;
    @NotEmpty
    private String reason;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ManualFullMoneyRefundReqV1Builder {}
}
