package ru.yandex.travel.api.endpoints.admin.req_rsp;

import java.util.Map;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;
import org.springframework.validation.annotation.Validated;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ManualMoneyRefundReqV1.ManualMoneyRefundReqV1Builder.class)
@Validated
public class ManualMoneyRefundReqV1 {
    @NotEmpty
    private String orderId;
    @NotNull
    private Map<Long, Money> refundsByFiscalItem;
    @NotEmpty
    private String adminActionToken;
    @NotEmpty
    private String reason;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ManualMoneyRefundReqV1Builder {}
}
