package ru.yandex.travel.api.endpoints.admin.req_rsp;

import java.time.LocalDate;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class ModifyHotelOrderDetailsReqV1 {
    @Data
    public static class ModifyDates {
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
        private LocalDate checkinDate;

        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
        private LocalDate checkoutDate;
    }

    @Data
    public static class GuestInfo {
        @NotNull
        private String firstName;

        @NotNull
        private String lastName;

        private Integer age;

        private boolean child;
    }

    @Data
    public static class ModifyGuests {
        @NotNull
        @Valid
        private List<GuestInfo> guests;
    }

    @NotEmpty
    private String orderId;

    @NotEmpty
    private String adminActionToken;

    @NotEmpty
    private String reason;

    @Valid
    private ModifyDates dates; // may  be null -> do not change dates

    @Valid
    private ModifyGuests guests; // may  be null -> do not change guests
}
