package ru.yandex.travel.api.endpoints.admin.req_rsp;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.orders.admin.proto.ENotificationTransportType;
import ru.yandex.travel.orders.admin.proto.ENotificationType;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "Запрос об отправке нотификации пользователю")
public class SendUserNotificationReqV1 {
    @NotNull
    @ParamName("orderId")
    @ApiParam(name = "order_id", value = "Order ID", required = true)
    private String orderId;

    @NotNull
    @ParamName("transport")
    @ApiParam(name = "transport", value = "Notification transport type", required = true)
    private ENotificationTransportType transport;

    @NotNull
    @ParamName("type")
    @ApiParam(name = "type", value = "Notification type", required = true)
    private ENotificationType type;

    @ParamName("orderRefundId")
    @ApiParam(name = "orderRefundId", value = "Refund ID for train refund e-mail", required = false)
    private String orderRefundId;
}
