package ru.yandex.travel.api.endpoints.administrator.req_rsp;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.administrator.workflow.proto.EHotelConnectionState;

@Getter
@RequiredArgsConstructor
public enum HotelConnectionState {
    UNKNOWN("UNKNOWN"),
    NEW("new"),
    PUBLISHING("publishing"),
    PUBLISHED("published"),
    UNPUBLISHED("unpublished"),
    MANUAL_VERIFICATION("manual_verification");

    private static Map<HotelConnectionState, EHotelConnectionState> toProtoConnectionStateMap = Map.of(
            UNKNOWN, EHotelConnectionState.CS_UNKNOWN,
            NEW, EHotelConnectionState.CS_NEW,
            PUBLISHING, EHotelConnectionState.CS_PUBLISHING,
            PUBLISHED, EHotelConnectionState.CS_PUBLISHED,
            UNPUBLISHED, EHotelConnectionState.CS_UNPUBLISHED,
            MANUAL_VERIFICATION, EHotelConnectionState.CS_MANUAL_VERIFICATION
    );

    private static Map<EHotelConnectionState, HotelConnectionState> fromProtoConnectionStateMap = Map.of(
            EHotelConnectionState.CS_UNKNOWN, UNKNOWN,
            EHotelConnectionState.CS_NEW, NEW,
            EHotelConnectionState.CS_PUBLISHING, PUBLISHING,
            EHotelConnectionState.CS_PUBLISHED, PUBLISHED,
            EHotelConnectionState.CS_UNPUBLISHED, UNPUBLISHED,
            EHotelConnectionState.CS_MANUAL_VERIFICATION, MANUAL_VERIFICATION
    );

    private final String value;

    @JsonCreator
    public static HotelConnectionState fromString(String value) {
        for (HotelConnectionState s : HotelConnectionState.values()) {
            if (s.value.equals(value)) {
                return s;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown hotel connection state %s", value)
        );
    }

    public static EHotelConnectionState convertToProto(HotelConnectionState connectionState) {
        if (toProtoConnectionStateMap.containsKey(connectionState)) {
            return toProtoConnectionStateMap.get(connectionState);
        } else {
            throw new RuntimeException(String.format("Connection state %s is not found in the mapping", connectionState));
        }
    }

    public static HotelConnectionState convertFromProto(EHotelConnectionState connectionState) {
        if (fromProtoConnectionStateMap.containsKey(connectionState)) {
            return fromProtoConnectionStateMap.get(connectionState);
        } else {
            throw new RuntimeException(String.format("Connection state %s is not found in the mapping", connectionState));
        }
    }

}
