package ru.yandex.travel.api.endpoints.administrator.req_rsp;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Getter
@RequiredArgsConstructor
public enum PartnerId {
    TRAVELLINE("travelline"),
    BNOVO("bnovo");

    private static Map<PartnerId, EPartnerId> partnerToPropPartnerMap = Map.of(
            TRAVELLINE, EPartnerId.PI_TRAVELLINE,
            BNOVO, EPartnerId.PI_BNOVO
    );

    private final String value;

    @JsonCreator
    public static PartnerId fromString(String value) {
        for (PartnerId s : PartnerId.values()) {
            if (s.value.equals(value)) {
                return s;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown partner %s", value)
        );
    }

    public static EPartnerId convertToProto(PartnerId partnerId) {
        if (partnerToPropPartnerMap.containsKey(partnerId)) {
            return partnerToPropPartnerMap.get(partnerId);
        } else {
            throw new RuntimeException(String.format("Partner %s is not found in the mapping", partnerId));
        }
    }

}
