package ru.yandex.travel.api.endpoints.administrator.req_rsp;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.administrator.grpc.proto.EInternalUnpublishedReason;

@Getter
@RequiredArgsConstructor
public enum UnpublishedReason {
    UNKNOWN("UNKNOWN"),
    AGENCY("agency"),
    ADDITIONAL_SERVICES("additional services"),
    APARTMENTS("apartments"),
    HOTEL_INITIATIVE("hotel initiative"),
    OTHER("other");

    private static Map<UnpublishedReason, EInternalUnpublishedReason> toProtoUnpublishedReasonMap = Map.of(
            UNKNOWN, EInternalUnpublishedReason.IUR_UNKNOWN,
            AGENCY, EInternalUnpublishedReason.IUR_AGENCY,
            ADDITIONAL_SERVICES, EInternalUnpublishedReason.IUR_ADDITIONAL_SERVICES,
            APARTMENTS, EInternalUnpublishedReason.IUR_APARTMENTS,
            HOTEL_INITIATIVE, EInternalUnpublishedReason.IUR_HOTEL_INITIATIVE,
            OTHER, EInternalUnpublishedReason.IUR_OTHER
    );

    private static Map<EInternalUnpublishedReason, UnpublishedReason> fromProtoUnpublishedReasonMap = Map.of(
            EInternalUnpublishedReason.IUR_UNKNOWN, UNKNOWN,
            EInternalUnpublishedReason.IUR_AGENCY, AGENCY,
            EInternalUnpublishedReason.IUR_ADDITIONAL_SERVICES, ADDITIONAL_SERVICES,
            EInternalUnpublishedReason.IUR_APARTMENTS, APARTMENTS,
            EInternalUnpublishedReason.IUR_HOTEL_INITIATIVE, HOTEL_INITIATIVE,
            EInternalUnpublishedReason.IUR_OTHER, OTHER
    );

    private final String value;

    @JsonCreator
    public static UnpublishedReason fromString(String value) {
        for (UnpublishedReason s : UnpublishedReason.values()) {
            if (s.value.equals(value)) {
                return s;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown unpublished reason %s", value)
        );
    }

    public static EInternalUnpublishedReason convertToProto(UnpublishedReason unpublishedReason) {
        if (toProtoUnpublishedReasonMap.containsKey(unpublishedReason)) {
            return toProtoUnpublishedReasonMap.get(unpublishedReason);
        } else {
            throw new RuntimeException(String.format("Unpublished reason %s is not found in the mapping", unpublishedReason));
        }
    }

    public static UnpublishedReason convertFromProto(EInternalUnpublishedReason unpublishedReason) {
        if (fromProtoUnpublishedReasonMap.containsKey(unpublishedReason)) {
            return fromProtoUnpublishedReasonMap.get(unpublishedReason);
        } else {
            throw new RuntimeException(String.format("Unpublished reason %s is not found in the mapping", unpublishedReason));
        }
    }

}
