package ru.yandex.travel.api.endpoints.avia.landings;

import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.avia.landings.exceptions.LandingNotFoundException;
import ru.yandex.travel.api.endpoints.avia.landings.req_rsp.LandingRouteReq;
import ru.yandex.travel.api.endpoints.avia.landings.req_rsp.LandingRouteRsp;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;
import ru.yandex.travel.commons.http.CommonHttpHeaders;
import ru.yandex.travel.credentials.UserCredentials;

@RestController
@RequestMapping(value = "/api/avia/")
@RequiredArgsConstructor
@Slf4j
public class LandingRouteController {
    private final ResponseProcessor responseProcessor;
    private final LandingRouteImpl impl;

    @ExceptionHandler(LandingNotFoundException.class)
    @ResponseStatus(HttpStatus.NOT_FOUND)
    public ResponseEntity<String> handleCanonicalNotFoundException(LandingNotFoundException e) {
        return ResponseEntity.status(HttpStatus.NOT_FOUND).contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    @RequestMapping(value = {"/v1/landing/route"}, method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
    @ApiOperation(value = "AviaLandingRoute")
    public DeferredResult<LandingRouteRsp> getLandingRoute(@Validated @BindFromQuery LandingRouteReq request) {
        return responseProcessor.replyWithFuture(
                "AviaLandingRoute",
                () -> impl.getLandingRoute(request, CommonHttpHeaders.get(), UserCredentials.get()));
    }
}
