package ru.yandex.travel.api.endpoints.avia_country_restrictions;

import java.util.NoSuchElementException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.avia_country_restrictions.exceptions.PointInfoNotFoundException;
import ru.yandex.travel.api.endpoints.avia_country_restrictions.req_rsp.v1.CountryRestrictionsByListReq;
import ru.yandex.travel.api.endpoints.avia_country_restrictions.req_rsp.v1.CountryRestrictionsByListRsp;
import ru.yandex.travel.api.endpoints.avia_country_restrictions.req_rsp.v1.CountryRestrictionsReq;
import ru.yandex.travel.api.endpoints.avia_country_restrictions.req_rsp.v1.CountryRestrictionsRsp;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;
import ru.yandex.travel.api.models.avia.country_restrictions.v1.ExtendedMetricsAnswer;

@RestController
@RequestMapping(value = "/api/avia_country_restrictions/")
@Api(value = "AviaCountryRestrictions")
@RequiredArgsConstructor
public class AviaCountryRestrictionsController {
    private final ResponseProcessor responseProcessor;
    private final AviaCountryRestrictionsImpl impl;

    @ExceptionHandler({PointInfoNotFoundException.class})
    @ResponseStatus(HttpStatus.NOT_FOUND)
    public String handlePointNotFoundException(PointInfoNotFoundException e) {
        return e.getMessage();
    }

    @ExceptionHandler({NoSuchElementException.class})
    @ResponseStatus(HttpStatus.NOT_FOUND)
    public String handleNoSuchElementException(NoSuchElementException e) {
        return e.getMessage();
    }

    @ExceptionHandler({IllegalArgumentException.class})
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public String handleIllegalArgumentException(IllegalArgumentException e) {
        return e.getMessage();
    }

    @RequestMapping(value = {"/v1/data"}, method = RequestMethod.GET, produces = "application/json")
    @ApiOperation(value = "Ограничения по странам")
    public DeferredResult<CountryRestrictionsRsp> getDataV1(@Validated @BindFromQuery CountryRestrictionsReq req) {
        return responseProcessor.replyWithFuture("AviaCountryRestrictionsDataV1", () -> impl.getDataV1(req));
    }

    @RequestMapping(value = {"/v1/extended"}, method = RequestMethod.GET, produces = "application/json")
    @ApiOperation(value = "Ограничения по странам")
    public DeferredResult<ExtendedMetricsAnswer> getExtendedV1(@Validated @BindFromQuery CountryRestrictionsReq req) {
        return responseProcessor.replyWithFuture("AviaCountryRestrictionsExtendedV1", () -> impl.getExtendedV1(req));
    }

    @RequestMapping(value = {"/v1/data-by-list"}, method = RequestMethod.POST, produces = "application/json")
    @ApiOperation(value = "Ограничения по въезду для заданного списка городов")
    public DeferredResult<CountryRestrictionsByListRsp> getDataByListV1(
            @RequestBody @Validated CountryRestrictionsByListReq req) {
        return responseProcessor.replyWithFuture(
                "AviaCountryRestrictionsDataByListV1", () -> impl.getDataByListV1(req));
    }
}
