package ru.yandex.travel.api.endpoints.booking_flow;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.api.services.hotels_booking_flow.BookingFlowContext;
import ru.yandex.travel.hotels.busbroker.BusBrokerClient;
import ru.yandex.travel.hotels.proto.EOfferInvalidationSource;

@Slf4j
@Component
@RequiredArgsConstructor
public class BookingFlowOfferInvalidator {
    private final BusBrokerClient busBrokerClient;
    private final Counter invalidationErrors = Metrics.counter("offer-invalidation.errors");

    public void invalidate(BookingFlowContext context) {
        try {
            if (context.getDecodedToken() == null) {
                invalidationErrors.increment();
                log.error("Can't create invalidation event without decoded token");
                return;
            }

            busBrokerClient.invalidateOffersByCheckInOut(
                    context.getDecodedToken().getPartnerId(),
                    context.getDecodedToken().getOriginalId(),
                    context.getDecodedToken().getCheckInDate(),
                    context.getDecodedToken().getCheckOutDate(),
                    EOfferInvalidationSource.OIS_BOOKING_PAGE);
        } catch (Exception e) {
            invalidationErrors.increment();
            log.error("Failed to send invalidation event", e);
        }
    }
}
