package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.api.endpoints.booking_flow.model.promo.AppliedPromoCampaignsDto;
import ru.yandex.travel.api.endpoints.booking_flow.validation.IpAddress;
import ru.yandex.travel.api.models.subscriptions.PromoSubscriptionRequestParams;

@Data
@EqualsAndHashCode(callSuper = true)
public class CreateV1HotelOrderRequest extends OrderGuestInfo {
    @NotBlank
    private String token;
    private String label;
    @NotBlank
    private String checksum;
    @IpAddress
    private String customerIp;
    @NotBlank
    private String customerUserAgent;
    @NotNull
    private String customerLogin;
    @NotBlank
    private String customerYandexUid;
    @NotNull
    private String customerPassportId;
    @NotEmpty
    private String sessionKey;
    @Min(0)
    @Max(10)
    private int selectedBedGroupIndex;

    private List<String> promoCodes;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private AppliedPromoCampaignsDto appliedPromoCampaigns;

    private PromoSubscriptionRequestParams subscriptionParams;

    private boolean useDeferredPayments;
    private boolean usePostPay;

    private String paymentTestContextToken;
}
