package ru.yandex.travel.api.endpoints.booking_flow.model;


import java.util.List;
import java.util.Map;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

public enum DisplayableOrderStatus {
    IN_PROGRESS("IN_PROGRESS"),
    AWAITS_PAYMENT("AWAITS_PAYMENT"),
    CANCELLED("CANCELLED"),
    FULFILLED("FULFILLED");

    private static Map<EDisplayOrderState, DisplayableOrderStatus> displayStateMap = Map.of(
            EDisplayOrderState.OS_IN_PROGRESS, DisplayableOrderStatus.IN_PROGRESS,
            EDisplayOrderState.OS_AWAITS_PAYMENT, DisplayableOrderStatus.AWAITS_PAYMENT,
            EDisplayOrderState.OS_CANCELLED, DisplayableOrderStatus.CANCELLED,
            EDisplayOrderState.OS_FULFILLED, DisplayableOrderStatus.FULFILLED,
            EDisplayOrderState.OS_REFUNDED, DisplayableOrderStatus.FULFILLED
    );

    private static Map<DisplayableOrderStatus, List<EDisplayOrderState>> displayableStatusMap = Map.of(
            DisplayableOrderStatus.IN_PROGRESS, List.of(EDisplayOrderState.OS_IN_PROGRESS),
            DisplayableOrderStatus.AWAITS_PAYMENT, List.of(EDisplayOrderState.OS_AWAITS_PAYMENT),
            DisplayableOrderStatus.CANCELLED, List.of(EDisplayOrderState.OS_CANCELLED),
            DisplayableOrderStatus.FULFILLED, List.of(EDisplayOrderState.OS_FULFILLED, EDisplayOrderState.OS_REFUNDED)
    );

    private final String value;


    DisplayableOrderStatus(String value) {
        this.value = value;
    }

    public static DisplayableOrderStatus fromValue(String text) {
        for (DisplayableOrderStatus s : DisplayableOrderStatus.values()) {
            if (String.valueOf(s.value).equals(text)) {
                return s;
            }
        }
        return null;
    }

    public static DisplayableOrderStatus fromProto(EDisplayOrderState protoState) {
        if (displayStateMap.containsKey(protoState)) {
            return displayStateMap.get(protoState);
        } else {
            throw new RuntimeException(String.format("Don't know how to map %s to DisplayableOrderStatus", protoState));
        }
    }

    public String getValue() {
        return value;
    }

    public List<EDisplayOrderState> getProtoStates() {
        return displayableStatusMap.getOrDefault(this, List.of());
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }
}
