package ru.yandex.travel.api.endpoints.booking_flow.model;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
public class ExtraFeeRate {
    private Type type;
    private RateDto payable;
    private RateDto face;
    public enum Type {
        MANDATORY_FEE("mandatory_fee"),
        RESORT_FEE("resort_fee"),
        MANDATORY_TAX("mandatory_tax");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromValue(String text) {
            for (Type b : Type.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

}
