package ru.yandex.travel.api.endpoints.booking_flow.model;

import lombok.Data;

@Data
public class FeeRate {
    private String amount;
    private String currency;
    private Type type;
    public enum Type {
        TAX_AND_SERVICE_FEE("tax_and_service_fee"),
        EXTRA_PERSON_FEE("extra_person_fee"),
        COMPENSATION("compensation"),
        PROPERTY_FEE("property_fee"),
        SALES_TAX("sales_tax"),
        ADJUSTMENT("adjustment");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromValue(String text) {
            for (Type b : Type.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }
}
