package ru.yandex.travel.api.endpoints.booking_flow.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.hotels.breadcrumbs.Breadcrumbs;
import ru.yandex.travel.hotels.common.LocationType;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GeoHotelInfo {
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Coordinates {
        double longitude;
        double latitude;
    }
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class LegalInfo {
        String inn;
        String ogrn;
        String address;
    }
    Long permalink;
    String hotelSlug; // Not persisted to Orders DB; always calculated by permalink
    String name;
    String address;
    String phone;
    Integer stars;
    Float rating;
    Coordinates coordinates;
    String imageUrlTemplate;
    String workingHours;
    LegalInfo legalInfo;
    LocationType locationType;
    Breadcrumbs breadcrumbs;
}
