package ru.yandex.travel.api.endpoints.booking_flow.model;

import javax.validation.constraints.Pattern;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import ru.yandex.misc.lang.StringUtils;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class Guest {
    @Pattern(regexp = "[a-zA-Z\\-а-яА-ЯёЁ\\s]*")
    @Length(max = 80)
    private String firstName;

    @Pattern(regexp = "[a-zA-Z\\-а-яА-ЯёЁ\\s]*")
    @Length(max = 80)
    private String lastName;

    public boolean isEmpty() {
        return StringUtils.isBlank(firstName) && StringUtils.isBlank(lastName);
    }
}
