package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.promo.AppliedPromoCampaignsDto;
import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.hotels.common.orders.RefundInfo;
import ru.yandex.travel.komod.trips.common.TripIdSetter;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

/**
 * DTO for {@link ru.yandex.travel.api.services.hotels_booking_flow.models.HotelOrder}
 */
@Data
public class HotelOrderDto implements TripIdSetter {
    private UUID id;
    private String yandexOrderId;
    private OfferDto orderInfo;
    private OrderGuestInfoDto guestInfo;
    private OrderStatus status;
    private EDisplayOrderState displayState;
    private CancellationDetails orderCancellationDetails;
    private PaymentDto payment;
    private ConfirmationInfo confirmationInfo;
    private RefundInfo refundInfo;
    private OrderPriceInfo orderPriceInfo;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private AppliedPromoCampaignsDto appliedPromoCampaigns;
    private UUID tripId;
    private Boolean canGenerateBusinessTripDoc;
}
