package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.promo.PromoCampaignsDto;
import ru.yandex.travel.api.models.common.ExtraVisitAndUserParams;
import ru.yandex.travel.api.models.hotels.HotelOffer;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
public class OfferDto {
    private String travelToken;
    private String label;
    private String checksum;
    private String sessionKey;
    private GeoHotelInfo basicHotelInfo;
    private PartnerHotelInfoDto partnerHotelInfo;
    private RoomContentDto partnerRoomInfo;
    private List<BedGroupDto> bedGroups;
    private RequestInfo requestInfo;
    private PriceInfo rateInfo;
    private LocalizedPansionInfo pansionInfo;
    @Deprecated
    private CancellationInfo cancellationInfo;
    private CancellationInfo cancellationInfoUnfiltered;
    private LegalInfo legalInfo;
    private EPartnerId partnerId;
    private Boolean directPartner;
    private PromoCampaignsDto promoCampaigns;
    private PaymentScheduleDto deferredPaymentSchedule;
    private boolean allowPostPay;
    private HotelOffer.CancellationInfo refundInfo;
    private boolean allGuestsRequired;
    @JsonIgnore
    private boolean priceMatch;

    public Boolean getDirectPartner() {
        if (directPartner != null) {
            return directPartner;
        }
        return partnerId == EPartnerId.PI_TRAVELLINE || partnerId == EPartnerId.PI_BNOVO;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private ExtraVisitAndUserParams extraVisitAndUserParams;
}
