package ru.yandex.travel.api.endpoints.booking_flow.model;

public enum OrderErrorType {
    PRICE_MISMATCH("price_mismatch"),
    PAYMENT_FAILURE("payment_failure"),
    CONFIRMATION_FAILURE("confirmation_failure"),
    UNKNOWN_ERROR("unknown_error");


    private String value;

    OrderErrorType(String value) {
        this.value = value;
    }

    public static OrderErrorType fromValue(String text) {
        for (OrderErrorType s : OrderErrorType.values()) {
            if (String.valueOf(s.value).equals(text)) {
                return s;
            }
        }
        return null;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }
}
