package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import ru.yandex.travel.api.endpoints.booking_flow.validation.GuestNames;
import ru.yandex.travel.api.endpoints.booking_flow.validation.Phone;

@Data
public class OrderGuestInfo {
    @NotBlank
    @Email
    @Length(max = 80)
    private String customerEmail;
    @NotBlank
    @Phone
    private String customerPhone;
    private boolean allowsSubscription;
    @NotEmpty
    @Valid
    @GuestNames
    private List<Guest> guests;
}
