package ru.yandex.travel.api.endpoints.booking_flow.model;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.orders.proto.EHotelOrderAggregateState;

public enum OrderStatus implements ValueBasedEnum<String> {
    IN_PROGRESS("IN_PROGRESS", EHotelOrderAggregateState.HOAG_IN_PROGRESS),
    RESERVED("RESERVED", EHotelOrderAggregateState.HOAG_RESERVED),
    RESERVED_WITH_RESTRICTIONS("RESERVED_WITH_RESTRICTIONS", EHotelOrderAggregateState.HOAG_RESERVED_WITH_RESTRICTIONS),
    AWAITS_PAYMENT("AWAITS_PAYMENT", EHotelOrderAggregateState.HOAG_AWAITS_PAYMENT),
    PAYMENT_FAILED("PAYMENT_FAILED", EHotelOrderAggregateState.HOAG_PAYMENT_FAILED),
    CONFIRMED("CONFIRMED", EHotelOrderAggregateState.HOAG_CONFIRMED),
    CANCELLED("CANCELLED", EHotelOrderAggregateState.HOAG_CANCELLED),
    CANCELLED_WITH_REFUND("CANCELLED_WITH_REFUND", EHotelOrderAggregateState.HOAG_CANCELLED_WITH_REFUND),
    REFUNDED("REFUNDED", EHotelOrderAggregateState.HOAG_REFUNDED),
    REFUND_FAILED("REFUND_FAILED", EHotelOrderAggregateState.HOAG_REFUND_FAILED),
    FAILED("FAILED", EHotelOrderAggregateState.HOAG_FAILED);

    private static EnumIndex<EHotelOrderAggregateState, OrderStatus> BY_PROTO =
            EnumIndex.create(OrderStatus.class, OrderStatus::getHotelOrderAggregateState);

    private static EnumIndex<String, OrderStatus> BY_VALUE = EnumIndex.create(OrderStatus.class);

    private String value;

    private EHotelOrderAggregateState hotelOrderAggregateState;

    OrderStatus(String value, EHotelOrderAggregateState hotelOrderAggregateState) {
        this.value = value;
        this.hotelOrderAggregateState = hotelOrderAggregateState;
    }

    public static OrderStatus fromValue(String text) {
        return BY_VALUE.getByValue(text);
    }

    public static OrderStatus fromAggregateState(EHotelOrderAggregateState aggregateState) {
        return BY_PROTO.getByValue(aggregateState);
    }

    public String getValue() {
        return value;
    }

    public EHotelOrderAggregateState getHotelOrderAggregateState() {
        return hotelOrderAggregateState;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }
}
