package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PartnerHotelInfoDto {
    private String propertyId;
    private String name;
    private String phone;
    private Address address;
    private Location location;
    private Ratings ratings;
    private Map<String, Amenity> amenities;
    private Descriptions descriptions;
    private List<ImageDto> images;
    private Checkin checkin;
    private Checkout checkout;
    private Fees fees;
    private Policies policies;

    @Data
    public static class Location {
        private Coordinates coordinates;
    }

    @Data
    public static class Coordinates {
        private BigDecimal latitude;
        private BigDecimal longitude;
    }

    @Data
    public static class Address {
        private String countryCode;
        private String city;
        @JsonProperty("line_1")
        private String line1;
        @JsonProperty("line_2")
        private String line2;
    }

    @Data
    public static class Ratings {
        private Rating property;
    }

    @Data
    public static class Rating {
        private String type;
        private String rating;
    }

    @Data
    public static class Amenity {
        private BigDecimal id;
        private String name;
    }

    @Data
    public static class Descriptions {
        private String location;
        private String rooms;
        private String dining;
        private String amenities;
        private String businessAmenities;
    }

    @Data
    public static class Checkin {
        private String beginTime;
        private String endTime;
        private String specialInstructions;
        private String instructions;
    }

    @Data
    public static class Checkout {
        private String time;
    }

    @Data
    public static class Fees {
        private String mandatory;
        private String optional;
    }

    @Data
    public static class Policies {
        private String knowBeforeYouGo;
    }

}
