package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.util.List;

import lombok.Builder;
import lombok.Data;
import org.javamoney.moneta.Money;

@Data
@Builder
public class PaymentDto {
    private CurrentPaymentDto current;
    private NextPaymentDto next;
    private PaymentErrorDto error;
    private List<ReceiptItem> receipts;
    private boolean mayBeStarted;
    private boolean mayBeCancelled;
    private boolean usesDeferredPayments;
    private Money amountPaid;
    private boolean usesZeroFirstPayment;


    public String getPaymentUrl() {
        if (current == null) {
            return null;
        } else {
            return current.getPaymentUrl();
        }
    }

    public PaymentErrorCode getErrorInfo() {
        if (error == null) {
            return null;
        } else {
            return error.getCode();
        }
    }
}
