package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.util.Optional;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.EPaymentErrorDisplayState;

public enum PaymentErrorCode {

    AUTHORIZATION_REJECT("authorization_reject", EPaymentErrorDisplayState.EPE_AUTHORIZATION_REJECT),
    EXPIRED_CARD("expired_card", EPaymentErrorDisplayState.EPE_EXPIRED_CARD),
    FAIL_3DS("fail_3ds", EPaymentErrorDisplayState.EPE_FAIL_3DS),
    LIMIT_EXCEEDED("limit_exceeded", EPaymentErrorDisplayState.EPE_LIMIT_EXCEEDED),
    NOT_ENOUGH_FUNDS("not_enough_funds", EPaymentErrorDisplayState.EPE_NOT_ENOUGH_FUNDS),
    TRANSACTION_NOT_PERMITTED("transaction_not_permitted", EPaymentErrorDisplayState.EPE_TRANSACTION_NOT_PERMITTED),
    USER_CANCELLED("user_cancelled", EPaymentErrorDisplayState.EPE_USER_CANCELLED),
    RESTRICTED_CARD("restricted_card", EPaymentErrorDisplayState.EPE_RESTRICTED_CARD),
    BLACKLISTED("blacklisted", EPaymentErrorDisplayState.EPE_BLACKLISTED),
    PAYMENT_TIMEOUT("payment_timeout", EPaymentErrorDisplayState.EPE_PAYMENT_TIMEOUT),
    OTHER(null, EPaymentErrorDisplayState.EPE_OTHER);

    public static final EnumIndex<String, PaymentErrorCode> BY_STRING =
            EnumIndex.createSelective(PaymentErrorCode.class,
            paymentError -> Optional.ofNullable(paymentError.errorCode)
    );

    public static final EnumIndex<EPaymentErrorDisplayState, PaymentErrorCode> BY_PROTO =
            EnumIndex.create(PaymentErrorCode.class, paymentError -> paymentError.paymentErrorDisplayState);

    private final String errorCode;

    private final EPaymentErrorDisplayState paymentErrorDisplayState;

    PaymentErrorCode(String errorCode, EPaymentErrorDisplayState paymentErrorDisplayState) {
        this.errorCode = errorCode;
        this.paymentErrorDisplayState = paymentErrorDisplayState;
    }

    public static PaymentErrorCode fromErrorCode(String errorCode) {
        PaymentErrorCode result = BY_STRING.getByValueOrNull(errorCode);
        if (result == null) {
            result = OTHER;
        }
        return result;
    }
}
