package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.math.RoundingMode;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class RateDto {
    private String amount;
    private String currency;

    public static RateDto fromMoney(Money amount) {
        return new RateDto(amount.getNumberStripped().setScale(2, RoundingMode.HALF_UP).toString(), amount.getCurrency().getCurrencyCode());
    }
}
