package ru.yandex.travel.api.endpoints.booking_flow.model;

import java.time.LocalDate;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RequestInfo implements OfferSearchParamsProvider {
    private LocalDate checkinDate;
    private LocalDate checkoutDate;
    private int numAdults;
    private List<Integer> childAges;
    private Integer selectedBedGroupIndex;

    @Override
    public Integer getAdults() {
        return numAdults;
    }

    @Override
    public List<Integer> getChildrenAges() {
        return childAges;
    }
}
