package ru.yandex.travel.api.endpoints.booking_flow.model.promo;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.hotels.common.orders.promo.AppliedPromoCampaigns;

@Data
@Builder
@Jacksonized
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AppliedPromoCampaignsDto {
    @Nullable
    private YandexPlusApplicationDto yandexPlus;
    @Nullable
    private WhiteLabelApplicationDto whiteLabel;

    public static AppliedPromoCampaigns convertToModel(AppliedPromoCampaignsDto campaignsDto) {
        return campaignsDto == null ? null : AppliedPromoCampaigns.builder()
                .yandexPlus(YandexPlusApplicationDto.convertToModel(campaignsDto.getYandexPlus()))
                .whiteLabel(WhiteLabelApplicationDto.convertToModel(campaignsDto.getWhiteLabel()))
                .build();
    }

    public static AppliedPromoCampaignsDto convertFromModel(AppliedPromoCampaigns campaigns) {
        return campaigns == null ? null : AppliedPromoCampaignsDto.builder()
                .yandexPlus(YandexPlusApplicationDto.convertFromModel(campaigns.getYandexPlus()))
                .whiteLabel(WhiteLabelApplicationDto.convertFromModel(campaigns.getWhiteLabel()))
                .build();
    }
}
