package ru.yandex.travel.api.endpoints.booking_flow.model.promo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.hotels.common.orders.promo.WhiteLabelApplication;

@Data
@Builder
@Jacksonized
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WhiteLabelApplicationDto {
    private String customerNumber;

    public static WhiteLabelApplication convertToModel(WhiteLabelApplicationDto dto) {
        return dto == null ? null : WhiteLabelApplication.builder()
                .customerNumber(dto.getCustomerNumber())
                .build();
    }

    public static WhiteLabelApplicationDto convertFromModel(WhiteLabelApplication whiteLabel) {
        return whiteLabel == null ? null : WhiteLabelApplicationDto.builder()
                .customerNumber(whiteLabel.getCustomerNumber())
                .build();
    }
}
