package ru.yandex.travel.api.endpoints.booking_flow.model.promo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;
import ru.yandex.travel.hotels.common.orders.promo.YandexPlusApplication;
import ru.yandex.travel.hotels.common.orders.promo.YandexPlusApplication.Mode;

@Data
@Builder
@Jacksonized
public class YandexPlusApplicationDto {
    private DtoMode mode;
    private Integer points;

    public static YandexPlusApplication convertToModel(YandexPlusApplicationDto dto) {
        return dto == null ? null : YandexPlusApplication.builder()
                .mode(dto.getMode().getModelMode())
                .points(dto.getPoints())
                .build();
    }

    public static YandexPlusApplicationDto convertFromModel(YandexPlusApplication yandexPlus) {
        return yandexPlus == null ? null : YandexPlusApplicationDto.builder()
                .mode(DtoMode.modeIndex.getByValue(yandexPlus.getMode()))
                .points(yandexPlus.getPoints())
                .build();
    }

    @AllArgsConstructor
    @Getter
    public enum DtoMode implements ValueBasedEnum<String> {
        TOPUP("TOPUP", Mode.TOPUP),
        WITHDRAW("WITHDRAW", Mode.WITHDRAW);

        private static final EnumIndex<String, DtoMode> index = EnumIndex.create(DtoMode.class);
        private static final EnumIndex<Mode, DtoMode> modeIndex = EnumIndex.create(DtoMode.class, m -> m.modelMode);

        @JsonValue
        private final String value;
        private final Mode modelMode;

        @JsonCreator
        public DtoMode forValue(String value) {
            return index.getByValue(value);
        }
    }
}
